/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.ConcordanceShell;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceItemComparer;
import net.nooj4nlp.controller.ConcordanceShell.ConcordanceShellController;
import net.nooj4nlp.controller.ConcordanceShell.CustomForegroundTableRenderer;
import net.nooj4nlp.engine.Language;

public class ConcordanceTableSorter
extends MouseAdapter {
    private ConcordanceShellController controller;
    private JTable concordanceTable;
    private DefaultTableModel tableModel;
    private int index;
    private Language lan;

    public ConcordanceTableSorter(ConcordanceShellController controller, JTable concordanceTable) {
        this.controller = controller;
        this.concordanceTable = concordanceTable;
        this.tableModel = (DefaultTableModel)this.concordanceTable.getModel();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        CustomForegroundTableRenderer customForegroundTableRenderer = (CustomForegroundTableRenderer)this.concordanceTable.getDefaultRenderer(Object.class);
        customForegroundTableRenderer.sortTableColors();
        this.controller.setTableModel(this.tableModel);
        JTable table = ((JTableHeader)e.getSource()).getTable();
        TableColumnModel colModel = table.getColumnModel();
        this.index = colModel.getColumnIndexAtX(e.getX());
        Vector<Vector> dataVector = this.tableModel.getDataVector();
        ArrayList<Vector> dataList = new ArrayList<Vector>(dataVector);
        ArrayList<Object[]> blackList = new ArrayList<Object[]>();
        ArrayList<Object[]> redList = new ArrayList<Object[]>();
        ArrayList<Object[]> greenList = new ArrayList<Object[]>();
        ArrayList<Object[]> blueList = new ArrayList<Object[]>();
        Map<Color, Integer> map = this.controller.getColorMap();
        this.lan = this.controller.getLan();
        for (int i = 0; i < dataList.size(); ++i) {
            Object[] tableRow = ((Vector)dataList.get(i)).toArray();
            int color = (Integer)tableRow[4];
            if (color == map.get(Color.BLACK)) {
                blackList.add(tableRow);
                continue;
            }
            if (color == map.get(Color.RED)) {
                redList.add(tableRow);
                continue;
            }
            if (color == map.get(new Color(20, 180, 62))) {
                greenList.add(tableRow);
                continue;
            }
            blueList.add(tableRow);
        }
        ArrayList<Object[]> newDataList = new ArrayList<Object[]>();
        Collections.sort(blackList, new ConcordanceItemComparer(this.index, this.lan.locale));
        Collections.sort(redList, new ConcordanceItemComparer(this.index, this.lan.locale));
        Collections.sort(greenList, new ConcordanceItemComparer(this.index, this.lan.locale));
        Collections.sort(blueList, new ConcordanceItemComparer(this.index, this.lan.locale));
        newDataList.addAll(blackList);
        newDataList.addAll(redList);
        newDataList.addAll(greenList);
        newDataList.addAll(blueList);
        DefaultTableModel newTableModel = new DefaultTableModel(new Object[]{"", "Before", "Seq.", "After", "Color", "Tag"}, 0);
        if (!ConcordanceShellController.isItAText) {
            newTableModel = new DefaultTableModel(new Object[]{"Text", "Before", "Seq.", "After", "Color", "Tag"}, 0);
        }
        for (int i = 0; i < newDataList.size(); ++i) {
            newTableModel.addRow((Object[])newDataList.get(i));
        }
        table.setModel(newTableModel);
        table.removeColumn(this.concordanceTable.getColumnModel().getColumn(5));
        table.removeColumn(this.concordanceTable.getColumnModel().getColumn(4));
        this.controller.setWidthOfTableColumn(table, newTableModel, 0);
        this.controller.setWidthOfTableColumn(table, newTableModel, 1);
        this.controller.setWidthOfTableColumn(table, newTableModel, 2);
        this.controller.setWidthOfTableColumn(table, newTableModel, 3);
        this.controller.setConcordanceTableSorted(true);
    }
}

